# cddconfig.py - Data handling routines developed by Optibrium for integration of CDD Vault with StarDrop software
# Use of this code is subject to the terms of the StarDrop License Agreement and use, copying or redistribution of
# this file for use by other persons or organisations is prohibited
# Copyright(C) Optibrium Ltd 2016
# stardrop-support@optibrium.com
#

"""Module to hold some configuration options for accessing CDD Vault from StarDrop"""
import logging

# Use this to toggle between servers, or to set a different one
url = "https://app.collaborativedrug.com/api/v1/vaults"
# url = "https://eu.collaborativedrug.com/api/v1/vaults"

# parameters for type detection of returned values
TYPE_CHECK_DEPTH = 100
TYPE_CHECK_FRACTION = 0.7
DATE_FORMAT = "%Y-%m-%d"
STANDARD_DEVIATION_SUFFIX = [" Standard Deviation (±)", " Standard Deviation (×/÷)"]

# parameter for whether to request sd-file format or csv-file format from CDD Vault.
SDFILE_REQUIRED = True

# parameter for deciding how to parse a molecule from an SD file (the molecule may be in SMILES or MOL-file format)
MAX_NUM_MOLECULES_TO_TEST_FOR_PARSING = 10

# parameter for the logging level of the program
LOGGING_LEVEL = logging.INFO
LOGGER_FILE = "cdd_vault_logs.txt"

# parameter for when to warn the user of a high number of plot images, which cause long download times.
HIGH_PLOT_RETRIEVAL_VALUE = 200

# parameter for if the user wants access to their response curve data.
ACCESS_RESPONSE_CURVES = True

CURVE_KEY_COLUMN_NAME = "Batch Molecule-Batch ID"


def get_token():
    """Attempt to read a saved token.
    @returns: A string token if available, otherwise an empty string
    """
    try:
        file = open('cddtoken.txt')
        token = file.read()
        file.close()
        return token
    except Exception as e:
        print(e)
        pass
    return ''


def set_token(token):
    """Save a token for fiture use.
    @param: token: The new token
    """
    try:
        file = open('cddtoken.txt', 'w')
        file.write(token)
        file.close()
    except Exception as e:
        print(e)
        pass
